/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.compat;

import java.util.ArrayList;
import java.util.function.Predicate;
import mcjty.rftoolsbase.api.storage.IStorageScanner;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.xnet.apiimpl.items.ItemChannelSettings;
import mcjty.xnet.apiimpl.items.ItemConnectorSettings;
import mcjty.xnet.setup.Config;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;

public class RFToolsSupport {
    public static boolean isStorageScanner(BlockEntity te) {
        return te instanceof IStorageScanner;
    }

    public static void tickStorageScanner(IControllerContext context, ItemConnectorSettings settings, BlockEntity te, ItemChannelSettings channelSettings) {
        IStorageScanner scanner = (IStorageScanner)te;
        Predicate<ItemStack> extractMatcher = settings.getMatcher(context);
        Integer count = settings.getCount();
        int amount = 0;
        if (count != null && (amount = scanner.countItems(extractMatcher, true, count)) < count) {
            return;
        }
        int cnt = 0;
        switch (settings.getStackMode()) {
            case SINGLE: {
                cnt = 1;
                break;
            }
            case STACK: {
                cnt = 64;
                break;
            }
            case COUNT: {
                cnt = settings.getExtractAmount();
            }
        }
        ItemStack stack = scanner.requestItem(extractMatcher, true, cnt, true);
        if (!stack.m_41619_()) {
            int toextract = stack.m_41613_();
            if (count != null) {
                int canextract = amount - count;
                if (canextract <= 0) {
                    return;
                }
                if (canextract < toextract) {
                    toextract = canextract;
                    if (toextract <= 0) {
                        stack.m_41764_(0);
                    } else {
                        stack.m_41764_(toextract);
                    }
                }
            }
            ArrayList<Pair<SidedConsumer, ItemConnectorSettings>> inserted = new ArrayList<Pair<SidedConsumer, ItemConnectorSettings>>();
            int remaining = channelSettings.insertStackSimulate(inserted, context, stack);
            if (!inserted.isEmpty() && context.checkAndConsumeRF(((Integer)Config.controllerOperationRFT.get()).intValue())) {
                channelSettings.insertStackReal(context, inserted, scanner.requestItem(extractMatcher, false, toextract - remaining, true));
            }
        }
    }

    public static int countItems(BlockEntity te, Predicate<ItemStack> matcher, int count) {
        IStorageScanner scanner = (IStorageScanner)te;
        return scanner.countItems(matcher, true, Integer.valueOf(count));
    }

    public static int countItems(BlockEntity te, ItemStack stack, int count) {
        IStorageScanner scanner = (IStorageScanner)te;
        return scanner.countItems(stack, true, Integer.valueOf(count));
    }

    public static ItemStack insertItem(BlockEntity te, ItemStack stack, boolean simulate) {
        IStorageScanner scanner = (IStorageScanner)te;
        return scanner.insertItem(stack, simulate);
    }
}

